<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Pancake
 *
 * A simple, fast, self-hosted invoicing application.
 *
 * This is the Catalan translation for Pancake.
 *
 * @package     Pancake
 * @author      Pancake Payments <support@pancakeapp.com> - https://www.pancakeapp.com
 * @author      Bruno De Barros <bruno@terraduo.com> - https://terraduo.com
 * @author      Albert Calvet (Translation) <info@albertcalvet.com> - http://www.albertcalvet.com
 * @copyright   Copyright (c) 2015, Pancake Payments
 * @license     https://www.pancakeapp.com/license
 * @link        https://www.pancakeapp.com
 * @since       Version 4.8.52
 */

// ------------------------------------------------------------------------

$lang = array (
  'global:overview' => 'Resum',
  'global:error' => 'Error',
  'global:pancakeby7am' => 'Pancake :1',
  'global:allrelatedmediacopyright' => 'Pancake i tots els mitjans relacionats tenen Copyright :1 :2',
  'global:insecure_action' => 'Una acció insegura s\'ha intentat però ha estat atrapada',
  'global:disabled_in_demo' => 'Algunes funcions d\'aquesta pàgina estan deshabilitades per a la demo.',
  'global:estimates' => 'Pressupostos',
  'global:estimate' => 'Pressupost',
  'global:incomplete_tasks' => 'Tasques incompletes',
  'global:completed_tasks' => 'Tasques completes',
  'global:projects' => 'Projectes',
  'global:tickets' => 'Tiquets',
  'global:project' => 'Projecte',
  'global:upload_failed' => 'Hi ha hagut un problema al pujar l\'arxiu. Si us plau, torneu a intentar-ho. Si el problema persisteix, poseu-vos en contacte amb support@pancakeapp.com.',
  'global:upload_not_allowed' => 'El tipus d\'arxiu del document que estava tractant de pujar no està permès. Si necessita carregar un arxiu d\'aquest tipus, si us plau comprimiu-lo en un arxiu .zip o qualsevol altre format d\'arxiu que vostè trobi apropiat.',
  'global:copied' => 'Copiat!',
  'global:sentbutunpaid' => 'Pendent (Enviat, però sense pagar)',
  'global:task' => 'Tasca',
  'global:clients' => 'Clients',
  'global:access_denied' => 'Accés denegat',
  'global:users' => 'Usuaris',
  'global:send_to_client' => 'Enviat al client',
  'global:couldnotsendemail' => 'No s\'ha pogut enviar el correu electrònic. Si us plau, verifiqueu la configuració.',
  'global:emailsent' => 'El correu electrònic ha estat enviat!',
  'global:yes' => 'Si',
  'global:no' => 'No',
  'global:notyetsent' => 'No enviat al client',
  'global:dontshowagain' => 'No mostrar novament',
  'global:enable' => 'Habilitar',
  'global:is_enabled' => 'Habilitat?',
  'global:is_completed' => 'Completat?',
  'global:Y' => 'S',
  'global:N' => 'N',
  'global:notes' => 'Notes',
  'global:description' => 'Descripció',
  'global:backtoadmin' => 'Tornar a Admin',
  'global:type' => 'Tipus',
  'global:name' => 'Nom',
  'global:first_name' => 'Primer nom',
  'global:last_name' => 'Cognom',
  'global:company' => 'Companyia',
  'global:for' => 'per',
  'global:from' => 'de',
  'global:phone' => 'Telèfon',
  'global:email' => 'Email',
  'global:contacts' => 'Contactes',
  'global:week' => 'Setmanalment',
  'global:na' => 'N/A',
  'global:quarterly' => 'Trimestralment',
  'global:every_six_months' => 'Cada 6 mesos',
  'global:statistics' => 'Estadístiques',
  'global:biyearly' => 'Cada 2 anys',
  'global:month' => 'Mensualment',
  'global:year' => 'Anualment',
  'global:fax' => 'Fax',
  'global:mobile' => 'Mòbil',
  'global:address' => 'Adreça',
  'global:api_key' => 'Clau d\'API',
  'global:website' => 'Lloc',
  'global:action' => 'Acció',
  'global:items' => 'Items',
  'global:reusableinvoiceitems' => 'Items de factura reutilitzables',
  'global:reusableinvoiceitems_description' => 'Hauria d\'utilitzar Elements de factura reutilitzables quan es vol tornar a utilitzar el mateix article en diferents factures. Per a utilitzar-los al crear o editar una factura, simplement comenci a escriure el nom de l\'element que ha guardat i s\'autocompletaran els detalls de l\'element per a vostè.',
  'global:create_invoice_estimate' => 'Crear factures i pressupostos per a recaptar diners.',
  'global:createinvoice' => 'Crear factura',
  'global:paid' => 'Pagat',
  'global:unpaid' => 'Sense pagar',
  'global:overdue' => 'Endarrerit',
  'global:time_entries' => 'Entrades de temps',
  'global:invoices' => 'Factures',
  'global:invoice' => 'Factura',
  'global:tasks' => 'Tasques',
  'global:dashboard' => 'Taulell de control',
  'global:settings' => 'Ajustos',
  'global:plugins' => 'Plugins',
  'global:installed' => 'Instal·lat',
  'global:changepassword' => 'Canviar Password',
  'global:logout' => 'Sortir',
  'global:status' => 'Estatus',
  'global:client' => 'Client',
  'global:user' => 'Usuari',
  'global:title' => 'Títol',
  'global:subtitle' => 'Subtítol',
  'global:to' => 'A (separar múltiples adreces amb una coma)',
  'global:subject' => 'Assumpte',
  'global:thanks' => 'Gràcies!',
  'global:proposals' => 'Propostes',
  'global:proposal' => 'Proposta',
  'global:reports' => 'Informes',
  'global:item' => 'Item',
  'global:report' => 'Informe',
  'global:saveandinsert' => 'Desar i inserir',
  'global:details' => 'Detalls',
  'global:license_key' => 'Clau de llicència',
  'global:version' => 'Versió :1',
  'global:content' => 'Contingut',
  'global:add' => 'Afegir',
  'global:edit' => 'Editar',
  'global:resend' => 'Re enviar',
  'global:sent' => 'Enviat',
  'global:not_sent' => 'No enviat',
  'global:view' => 'Veure',
  'global:delete' => 'Esborrar',
  'global:remove' => 'Remoure',
  'global:sort' => 'Ordenar',
  'global:deleteitem' => 'Eliminar item',
  'global:dragtoreorder' => 'Arrossegar per reordenar',
  'global:start' => 'Començar',
  'global:stop' => 'Aturar',
  'global:start_timer' => 'Inicia temporitzador',
  'estimates:create' => 'Crear Pressupost',
  'global:stop_timer' => 'Aturar temporitzador',
  'global:created' => 'Creat',
  'global:updated' => 'Actualitzat',
  'global:update' => 'Actualitzar',
  'global:update_available' => ':1 Actualització disponible',
  'global:updates_available' => ':1 Actualitzacions disponibles',
  'global:downloadpdf' => 'Descarregar PDF',
  'global:yesdelete' => 'Si, esborrar!',
  'global:confirm_emphisised' => 'No hi ha marxa enrere!',
  'global:color' => 'Color',
  'global:save' => 'Desar',
  'global:unknown' => 'Desconegut',
  'global:upload_ini_size' => 'El fitxer que has pujat excedeix el límit de mida imposat per la instal·lació de PHP.',
  'global:upload_error' => 'Hi ha hagut un problema al pujar l\'arxiu. Si us plau, intenta-ho de nou.',
  'global:recurring' => 'Recurrent',
  'global:unsent' => 'Sense enviar',
  'global:converttoproject' => 'Convertir a Projecte',
  'global:converttoinvoice' => 'Convertir a Factura',
  'global:viewpdf' => 'Veure PDF',
  'global:duplicate' => 'Duplicar',
  'global:urltosend' => 'Aquí està la url per enviar:',
  'global:copytoclipboard' => 'Copiar al portapapers',
  'global:you_need_pancake_cron_job' => 'Per a utilitzar factures recurrents, has d\'estar executant treballs CRON amb Pancake.',
  'global:quick_links' => 'Enllaços ràpids',
  'global:view_all' => 'Veure tot',
  'global:deleted' => 'Esborrats',
  'global:add_more' => 'Afegir més',
  'global:upload_files' => 'Pujar arxius',
  'global:optional_increment' => '<strong>Opcional</strong> - s\' autoincrementarà',
  'login:ahoy' => 'Iepa!',
  'login:readytodothis' => 'A punt ??',
  'login:sup' => 'kipa shushetumare?',
  'global:actions' => 'Accions',
  'global:select' => '--- Seleccionar ---',
  'global:mark_as_unanswered' => 'Marcar sense resposta',
  'global:mark_as_accepted' => 'Marcar com a acceptat',
  'global:mark_as_rejected' => 'Marcar com a rebutjat',
  'global:reject_estimate' => 'Rebutjar pressupost',
  'global:accept_estimate' => 'Acceptar pressupost',
  'global:estimate_rejected' => 'Pressupost rebutjat',
  'global:estimate_accepted' => 'Pressupost acceptat',
  'global:reject_proposal' => 'Rebutjar proposta',
  'global:accept_proposal' => 'Acceptar proposta',
  'global:proposal_rejected' => 'Proposta rebutjada',
  'global:proposal_accepted' => 'Proposta acceptada',
  'global:client_area' => 'Àrea de clients',
  'global:admin' => 'Admin',
  'global:all_settings' => 'Tots els ajustos',
  'global:viewable' => 'Visible a l\'àrea del client',
  'global:not_viewable' => 'No visible a l\'àrea del client',
  'global:milestones' => 'Fites',
  'dashboard:collected' => 'Recol·lectat',
  'dashboard:outstanding' => 'Pendent',
  'dashboard:latest_activity' => 'Activitat recent',
  'dashboard:these_are_your_upcoming_tasks' => 'Aquestes són les seves properes tasques, :1.',
  'dashboard:upcoming_tasks' => 'Properes tasques',
  'login:forgotinstructions' => 'Introduïu la vostra adreça de correu electrònic perquè puguem enviar-li un correu electrònic per restablir la contrasenya.',
  'login:reset' => 'Reinicialitzar Contrasenya',
  'login:username' => 'Usuari',
  'login:password' => 'Contrasenya',
  'login:changepassword' => 'Canviar Contrasenya',
  'login:email' => 'Email',
  'login:login' => 'Login',
  'login:logout' => 'Sortir',
  'login:remember' => 'Recordar-me',
  'login:forgot' => 'Heu perdut la contrasenya?',
  'login:cancel' => '&laquo; Cancelar',
  'groups:edit_title' => 'Editar Grup %s',
  'groups:add_title' => 'Afegir grup d\'usuaris',
  'clients:title' => 'Tots els clients',
  'clients:filter' => 'Filtrar Client',
  'clients:add' => 'Afegir Client',
  'clients:removefilter' => 'Eliminar Filtre',
  'clients:edit' => 'Editar Client',
  'clients:noclienttitle' => 'Cal introduir alguns clients!',
  'clients:noclientbody' => 'Així que vostè pot enviar algunes factures. Afegir una ara? ',
  'clients:noclienttitlefilter' => 'No hi ha clients que coincideixin amb el seu filtre',
  'clients:hasnoinvoicetitle' => 'Genial! el client ha estat agregat!',
  'clients:hasnoinvoicebody' => 'Crear una factura per a ells i obtenir pagaments! Afegir una ara?',
  'clients:added' => 'El client ha estat afegit!',
  'clients:edited' => 'El client ha estat actualitzat!',
  'clients:deleted' => 'El client ha estat eliminat!',
  'clients:does_not_exist' => 'Aquest client no existeix!',
  'clients:health_check' => 'Revisió de salut',
  'clients:all' => 'Tot',
  'clients:delete_title' => 'Eliminar aquest client?!?!',
  'clients:delete_message' => 'Segur que vols esborrar aquest client? <br /> Això també eliminarà totes les seves factures, projectes i propostes.',
  'clients:clientaction' => '&nbsp;',
  'clients:passphrase' => 'Paraula de pas',
  'clients:bad_passphrase' => 'La paraula de pas és incorrecta.',
  'clients:total_clients' => 'Clients totals',
  'clients:support' => 'Suport',
  'clients:support_rates' => 'Valor de suport',
  'clients:edit_support_rates' => 'Establir tarifes',
  'contact:title' => 'Històric de contacte recent',
  'contact:method' => 'Mètode de contacte',
  'contact:contact' => 'Contacte',
  'contact:subject' => 'Subjecte',
  'contact:content' => 'Contingut',
  'contact:calling_title' => 'Trucant client ":1"',
  'invoices:markassent' => 'Marcar com a enviat',
  'invoices:invoicedate' => 'Data de la factura',
  'invoices:file_name' => 'Nom de l\'arxiu',
  'invoices:date_created' => 'Data de creació',
  'invoices:size' => 'Mida',
  'invoices:files' => 'Arxius',
  'invoices:sentbutunpaid' => 'Factures enviades al client però encara impagades',
  'invoices:duplicated' => 'Duplicat de la factura #:1. El nombre de la nova factura és el #:2.',
  'invoices:all' => 'Totes les factures',
  'invoices:empty' => 'No hi ha factures encara.',
  'invoices:overdue' => 'Factures vençudes',
  'invoices:tax_collected' => 'Impostos recol·lectats',
  'invoices:paid' => 'Factures pagades',
  'invoices:recurringinvoices' => 'Factures recurrents',
  'invoices:unsentinvoices' => 'Factures sense enviar',
  'invoices:unpaid' => 'Factures impagades',
  'invoices:thisinvoicewaspaidon' => 'Aquesta factura es va pagar el :1. Gràcies!',
  'invoices:senton' => 'Enviat el :1',
  'invoices:lastsenton' => 'Darrera enviada el :1 a les :2',
  'invoices:paidon' => 'Pagada el :1',
  'invoices:paidonsingle' => 'Pagada el',
  'invoices:thisinvoiceisunpaid' => 'Aquesta factura no ha estat pagada encara.',
  'invoices:noinvoicetitle' => 'No hi ha factures pendents!',
  'invoices:noinvoicesforthefilteredclient' => 'No teniu factures per :1.',
  'invoices:noinvoicebody' => 'Hauries de crear una factura ara! <br /> Els clients estimen les factures!',
  'invoices:send_now_title' => 'Enviar factura ara?',
  'invoices:send_now_body' => 'Ompli el següent formulari i enviarem la factura per vostè.',
  'invoices:newinvoice' => 'Crear factura',
  'invoices:send_now' => 'Enviar factura',
  'invoices:timequantity' => 'Temps/Quantitat',
  'invoices:ratewithcurrency' => 'Tarifa (:1)',
  'invoices:taxable' => 'Imposable',
  'invoices:total' => 'Total',
  'invoices:amount' => 'Monto',
  'invoices:due' => 'Venç',
  'invoices:subtotal' => 'Subtotal',
  'invoices:totaltax' => 'Impost total',
  'invoices:filestodownload' => 'Arxius per descarregar',
  'invoices:added' => 'La factura ha estat afegida!',
  'invoices:fileswillbeavailableafterpay' => 'Aquests arxius estaran disponibles per a baixar una vegada que la factura hagi estat pagat en la seva totalitat.',
  'invoices:no_payment_gateways_enabled' => 'No hi ha passarel·les de pagament, el que podria fer que sigui difícil pagar. Habilitar a <a href=":1"> Ajustaments </a>',
  'invoices:invoicenumber' => 'Factura #:1',
  'invoices:number' => 'Factura #',
  'invoices:type' => 'Tipus de factura',
  'invoices:is_recurring' => 'Recurrent?',
  'invoices:is_paid' => 'Pagat?',
  'invoices:is_sent' => 'Enviat?',
  'invoices:date_entered' => 'Data de creació',
  'invoices:delete_title' => 'Esborrar aquesta factura?',
  'items:select_time_entry' => 'Entrada temporal',
  'invoices:delete_message' => 'Segur que vols eliminar aquesta factura?',
  'invoices:create' => 'Crear factura',
  'invoices:edit' => 'Editar factura',
  'invoices:amountrequired' => 'El camp Quantitat és necessari',
  'invoices:currencydoesnotexist' => 'Aquesta moneda no existeix.',
  'invoices:unique_id' => 'ID únic',
  'invoices:willreoccurin' => 'Aquesta factura re-ocorrerà el :1.',
  'invoices:willbesentautomatically' => 'El client serà notificat per correu electrònic sobre aquesta factura el :1.',
  'invoices:thisisareoccurrence' => 'Aquesta factura és una repetició de la factura :1.',
  'invoices:clientlastnotifiedon' => 'El client va ser notificat per correu electrònic sobre aquesta factura el :1.',
  'invoices:simple' => 'Simple',
  'invoices:simple_help' => 'Una factura senzilla no té elements de línia. Simplement un total.',
  'invoices:detailed' => 'Detallada',
  'invoices:detailed_help' => 'Factures detallades permetrà tenir diversos elements de línia.',
  'invoices:estimate_help' => 'Els pressupostos són factures detallades que no són facturables.',
  'invoices:unpaid_totalamount' => 'Sense pagar / Suma total',
  'invoices:saveinvoice' => 'Desar factura',
  'invoices:deleted' => 'La factura ha estat eliminada!',
  'invoices:view' => 'Veure factura',
  'invoices:is_viewable' => 'Mostrar a l\'àrea del client?',
  'invoices:no_invoices' => 'No hi ha factures.',
  'invoices:addedsuccess' => 'Heu afegit una factura per',
  'invoices:invoice' => 'factura',
  'invoices:addedconf' => 'Heu afegit una factura # <strong>:1</strong>, totalitzant <strong>:2</strong> (:3 amb impostos) per :4:5.',
  'invoices:preview' => 'Previsualitzar factura',
  'invoices:editinvoice' => 'Editar factura #:1',
  'invoices:messageupdated' => 'La factura ha estat actualitzada!',
  'invoices:resend' => 'Reenviar factura',
  'invoices:client_viewed' => ':1 va veure <a href=":2">factura #:3</a> el :4',
  'invoices:client_paid' => ':1 va pagar <a href=":2">factura #:3</a> el :4',
  'invoice:paid_amount' => 'Suma pagada',
  'estimates:attachedtoproposal' => 'S\'adjunta a la proposta #:1',
  'estimates:duplicated' => 'Duplicat pressupost #:1. El nombre del nou pressupost és #:2.',
  'estimates:alltitle' => 'Tots els pressupostos',
  'estimates:attachingtoproposal' => 'Afegint pressupost a la proposta, si us plau esperi...',
  'estimates:delete_title' => 'Eliminar aquest pressupost?',
  'estimates:delete_message' => 'Segur que vols eliminar aquest pressupost?',
  'estimates:createnew' => 'Crear pressupost',
  'estimates:generate_estimate' => 'Generar pressupost',
  'estimates:converted' => 'Pressupost #:1 convertit a projecte.',
  'estimates:converted_to_invoice' => 'Pressupost #:1 convertit a factura.',
  'estimates:noestimatetitle' => 'No teniu pressupostos',
  'estimates:noestimatesforthisclient' => 'No teniu pressupostos per a aquest client.',
  'estimates:noestimatesforthefilteredclient' => 'No teniu pressupostos per :1.',
  'estimates:deleted' => 'El pressupost ha estat eliminat!',
  'estimates:noestimatebody' => 'Crear un ara?',
  'estimates:estimatenumber' => 'Pressupost #:1',
  'estimates:view' => 'Veure pressupost',
  'estimates:no_estimates' => 'No hi ha pressupostos.',
  'estimates:addedsuccess' => 'Heu afegit un pressupost per a',
  'estimates:estimate' => 'pressupost',
  'estimates:added' => 'El pressupost s\'ha afegit correctament',
  'estimates:addedconf' => 'Ha afegit pressupost #<strong>:1</ strong>, per un total de <strong>:2</strong> (:3 amb impostos) per :4:5.',
  'estimates:send_now_title' => 'Enviar pressupost ara?',
  'estimates:send_now_body' => 'Ompli el següent formulari i enviarem el pressupost.',
  'estimates:send_now' => 'Enviar pressupost',
  'estimates:edit' => 'Editar pressupost',
  'estimates:preview' => 'Previsualitzar pressupost',
  'estimates:editestimate' => 'Editar pressupost #:1',
  'estimates:messageupdated' => 'El pressupost ha estat actualitzat!',
  'estimates:client_viewed' => ':1 ver <a href=":2">pressupost #:3</a> el :4',
  'estimates:client_accepted' => ':1 aceptat <a href=":2">pressupost #:3</a> el :4',
  'estimates:client_rejected' => ':1 rebutjat <a href=":2">pressupost #:3</a> el :4',
  'estimates:resend' => 'Reenviar pressupost',
  'estimates:estimatedate' => 'Data estimada',
  'projects:status_id' => 'Estat de la tasca',
  'projects:projected' => 'Projectat',
  'projects:projected_hours' => 'Hores projectades',
  'projects:navigationitem' => 'Projectes',
  'projects:hours_worked' => 'Nombre d\'hores treballades',
  'projects:hours_worked_short' => 'Hores treballades',
  'projects:alltitle' => 'Tots els projectes',
  'projects:totalprojects' => 'Total Projectes',
  'projects:noprojecttitle' => 'No hi ha projectes encara!',
  'projects:noprojecttext' => 'Vols crear un ara?',
  'projects:add' => 'Crear projecte',
  'projects:createfromtemplate' => 'Crear projecte des de plantilla',
  'projects:doesnotexist' => 'El projecte al que estàs intentant accedir no existeix.',
  'projects:edit' => 'Editar projecte',
  'projects:delete' => 'Elimina projecte',
  'projects:project' => 'Projecte',
  'projects:new_project_from_estimate_without_number' => 'Nou projecte des de pressupost',
  'projects:new_project_from_estimate_with_number' => 'Nou projecte des de pressupost nro #:1',
  'projects:due_date' => 'Data de lliurament',
  'projects:is_completed' => 'Completat?',
  'projects:manage_project' => 'Gestionar projecte',
  'projects:areyousuredeletetask' => 'Segur que vols eliminar aquesta tasca?',
  'projects:add_time' => 'Afegir entrada temporal',
  'projects:add_hours' => 'Afegir hores',
  'projects:generate_invoice' => 'Generar factura',
  'projects:no_projects' => 'No hi ha projectes.',
  'projects:archive_proj' => 'Arxivar projecte',
  'projects:unarchive_proj' => 'Desarxivar projecte',
  'projects:archive' => 'Veure arxiu',
  'projects:active' => 'Projectes actius',
  'projects:archived' => 'Projectes arxivats',
  'projects:noarchivedprojecttitle' => 'No hi ha projectes arxivats.',
  'projects:noarchivedprojecttext' => 'Podeu arxivar un projecte des de la pàgina del projecte',
  'projects:allarchivedtitle' => 'Tots els projectes arxivats',
  'projects:templatize' => 'Desa com a plantilla',
  'projects:milestone_identifier' => '[Fita: :1]',
  'milestones:add' => 'Afegir Fita',
  'milestones:edit' => 'Editar Fita',
  'milestones:delete' => 'Elimina Fita',
  'milestones:milestone' => 'Fita',
  'milestones:target_date' => 'Data Estimada',
  'milestones:assigned_user' => 'Usuari assignat',
  'milestones:select_default' => '-- No hi ha fites --',
  'milestones:no_milestone' => 'Tasques sense fita',
  'milestones:add_success' => 'Fita ":1" afegida correctament!',
  'milestones:edit_success' => 'Fita ":1" editada correctament!',
  'milestones:add_failed' => 'Fita ":1" no ha pogut estar afegida.',
  'milestones:edit_failed' => 'Fita ":1" no ha pogut estar editada.',
  'milestones:are_you_sure_delete' => 'Segur que vols eliminar aquesta fita?',
  'milestones:delete_success' => 'Fita ":1" eliminada correctament!',
  'milestones:does_not_exist' => 'Aquesta fita no existeix.',
  'milestones:select_assignee_default' => 'Sense assignar',
  'proposal:outline' => 'Esbós de proposta',
  'reminders:reminders' => 'Recordatoris',
  'reminders:send' => 'Enviar Recordatoris',
  'reminders:success' => 'Aquests recordatoris han estat enviats!!',
  'reminders:remind' => 'Recordar',
  'reminders:message' => 'Missatge',
  'reminders:due' => 'Dies',
  'reminders:details' => 'Detalls',
  'reminders:log' => 'Registre',
  'emailtemplates:email_templates' => 'Plantilles de correu',
  'emailtemplates:create_template' => 'Crear plantilla',
  'emailtemplates:add' => 'Crear nova plantilla de correu',
  'emailtemplates:edit' => 'Editar plantilla de correu',
  'emailtemplates:manage' => 'Gestionar plantilles',
  'emailtemplates:name' => 'Nom del correu',
  'emailtemplates:subject' => 'Assumpte del correu',
  'emailtemplates:days' => 'Rang de dies',
  'emailtemplates:type' => 'Tipus de plantilla',
  'emailtemplates:success' => 'Plantilla de correu electrònic creada amb èxit',
  'emailtemplates:edited' => 'Plantilla de correu electrònic editada amb èxit',
  'emailtemplates:does_not_exist' => 'Plantilla de correu no existeix',
  'emailtemplates:deleted' => 'Plantilla de correu electrònic eliminada correctament',
  'emailtemplates:delete_title' => 'Eliminar plantilla de correu electrònic',
  'emailtemplates:delete_message' => 'Esteu segur que voleu eliminar aquesta plantilla de correu electrònic?',
  'reports:perclient' => 'per client',
  'reports:datefrom' => 'Des de',
  'reports:allclients' => 'Tots els clients',
  'reports:dateto' => 'Per',
  'reports:byclient' => 'Client',
  'reports:view' => 'Veure informe',
  'reports:show_all' => 'Mostrar informes',
  'reports:paid_and_unpaid' => 'Pagats i sense pagar',
  'reports:paid_vs_unpaid_over_time' => 'Pagat vs. Sense pagar en el temps',
  'reports:per_client' => 'per client',
  'reports:total_with_tax' => 'Total (amb impost)',
  'reports:total_without_tax' => 'Total (sense impost)',
  'reports:total_collected' => 'Total Recol·lectat',
  'reports:fees_paid' => 'Honoraris pagats',
  'reports:total_amount' => 'Suma total',
  'reports:paid_amount' => 'Suma pagada',
  'reports:unpaid_amount' => 'Suma sense pagar',
  'reports:client_name' => 'Nom del client',
  'reports:nodata' => 'Sense :1.',
  'currencies:default' => '[Per defecte] :1',
  'currencies:cad' => 'Dòlar canadenc',
  'currencies:eur' => 'Euro',
  'currencies:usd' => 'U.S. Dollar',
  'currencies:gbp' => 'Lliura esterlina',
  'currencies:hkd' => 'Dòlar de Hong Kong',
  'currencies:php' => 'Pes Filipí',
  'currencies:zar' => 'Rand de Sud-Àfrica',
  'proposals:duplicated' => 'Proposta duplicada #:1. El número de la nova proposta és #:2.',
  'proposals:usesectiontemplate' => 'Utilitzar aquesta plantilla de secció',
  'proposals:showcontents' => 'Mostrar continguts',
  'proposals:hidecontents' => 'Amagar continguts',
  'proposals:deletepremadesection' => 'Esborrar plantilla de secció',
  'proposals:nopremadesections' => 'No teniu plantilles de secció guardades.',
  'proposals:newproposal' => 'Nova proposta',
  'proposals:number' => 'Proposta #',
  'proposals:all' => 'Totes les propostes',
  'proposals:noproposaltitle' => 'No hi ha propostes!',
  'proposals:noproposalbody' => 'Hauries de crear una proposta ara, definitivament!',
  'proposals:client_viewed' => ':1 vista <a href=":2">proposta #:3</a> el :4',
  'proposals:client_accepted' => ':1 acceptada <a href=":2">proposta #:3</a> el :4',
  'proposals:client_rejected' => ':1 rebutjada <a href=":2">proposta #:3</a> el :4',
  'proposals:rejected' => 'Rebutjada el :1',
  'proposals:accepted' => 'Acceptada el :1',
  'proposals:lastviewed' => 'Darrer cop revisada pel client el :1, a les :2.',
  'proposals:neverviewed' => 'no ha estat revisada pel client.',
  'proposals:noanswer' => 'Sense resposta',
  'proposals:createproposal' => 'Crear proposta',
  'proposals:editproposal' => 'Editar proposta',
  'proposals:createdsuccessfully' => 'Proposta creada!',
  'proposals:sections' => 'Seccions',
  'proposals:section' => 'Secció',
  'proposals:createsection' => 'Afegir nova secció',
  'proposals:createpage' => 'Afegir pàgina',
  'proposals:emptysection' => '(Sense títol)',
  'proposals:emptycontents' => '(Sense continguts)',
  'proposals:emptysubtitle' => '(Sense subtítol)',
  'proposals:for' => 'Proposta per a:',
  'proposals:pagexofcount' => 'Pàgina :1 de :2',
  'proposals:saving' => 'Desant...',
  'proposals:save' => 'Desar proposta',
  'proposals:savepremade' => 'Desar la plantilla de secció',
  'proposals:addestimate' => 'Afegir pressupost',
  'proposals:saved' => 'Desat!',
  'proposals:createandedit' => 'Següent: Editar contingut de la proposta',
  'proposals:delete_message' => 'Segur que vols eliminar aquesta proposta??',
  'proposals:createpremadesection' => 'Afegir des plantilla de secció',
  'proposals:selected_attachments' => 'Tria pressupost',
  'proposals:attach_selected_estimate' => 'Adjuntar el pressupost seleccionat',
  'proposals:proposal' => 'Proposta',
  'proposals:status' => 'Estat',
  'proposals:view' => 'Veure proposta',
  'proposals:estimate' => 'Pressupost',
  'proposals:no_proposals' => 'No hi ha propostes.',
  'proposals:proposal_title' => 'Títol de la proposta',
  'proposals:kitchennotice' => 'Nota: Propostes apareixeran en :1 una vegada que el client hagi revisat l\'enllaç de la proposta. Això vol dir que tu pots editar totes les vegades que vulguis, el client no ho veurà fins que vostè vulgui.',
  'tasks:task' => 'Tasques',
  'tasks:edit_succeeded' => 'Editada la tasca amb èxit.',
  'tasks:hours' => 'Hores',
  'tasks:due_date' => 'Data de venciment',
  'tasks:is_completed' => 'Completat?',
  'tasks:timer' => 'Timer',
  'tasks:rate' => 'Tarifa',
  'tasks:default_rate' => 'Tarifa per defecte',
  'tasks:entries' => 'Entrades de temps',
  'tasks:view_entries' => 'Veure entrades',
  'tasks:edit_entry' => 'Editar entrada',
  'tasks:create' => 'Afegir tasca',
  'tasks:create_sub' => 'Afegir sub-tasca',
  'tasks:task_parent' => 'Tasca Pare',
  'tasks:edit' => 'Editar tasca',
  'tasks:create_succeeded' => 'La tasca ha estat creada!',
  'tasks:no_task_title' => 'Hmm, no hi ha tasques encara...',
  'tasks:no_task' => 'No hi ha tasques',
  'tasks:no_task_message' => 'Has de crear tasques!',
  'tasks:is_viewable' => 'Visible a l\'àrea del client?',
  'tasks:no_milestones' => 'Tasques sense fites associades',
  'tasks:not_related_to_a_task' => '-- No relacionat a una tasca --',
  'tasks:select_parent_default' => '-- Sense tasca pare --',
  'tasks:timers_running' => 'Rellotges corrent',
  'tasks:task_completed_by' => ':1 Completada <a href=":2">tasca :3</a> a les :4',
  'tasks:discussion' => 'Discussió: ',
  'tasks:billed_hours' => 'Hores facturades',
  'tasks:unbilled_hours' => 'Hores sense facturar',
  'users:create_user' => 'Crear usuari',
  'users:confirm_delete_emphasised' => 'No hi ha marxa enrere!',
  'items:name' => 'Nom de l\'ítem',
  'items:description' => 'Descripció de l\'item',
  'items:qty_hrs' => 'Quant. / Hrs.',
  'items:quantity' => 'Quantitat',
  'items:rate' => 'Tarifa',
  'items:tax_rate' => 'Impost',
  'items:cost' => 'Cost',
  'items:line_items' => 'Elements de línia',
  'items:add' => 'Afegir Ítem',
  'items:edit' => 'Editar Ítem',
  'items:noitemtitle' => 'No teniu ítems encara!',
  'items:noitembody' => 'Hauries d\'afegir ítems ara, facilita la creació de factures',
  'items:delete_title' => 'Eliminar aquest ítem?',
  'items:delete_message' => 'Segur que vols esborrar aquest ítem ":1"?',
  'items:type' => 'Tipus',
  'items:select_standard' => 'Estàndard',
  'items:select_expense' => 'Despesa',
  'items:add_expense_to_project' => 'Afegir despesa',
  'items:expenses' => 'Despeses',
  'expenses:expenses' => 'Despeses',
  'expenses:add' => 'Afegir despesa',
  'expenses:edit_expense' => 'Editar despesa',
  'expenses:delete' => 'Elimina despesa',
  'expenses:deleted' => 'Despesa eliminada',
  'expenses:all' => 'Totes les despeses',
  'expenses:amount' => 'Suma',
  'expenses:supplier' => 'Proveïdor',
  'expenses:suppliers' => 'Proveïdors',
  'expenses:category' => 'Categoria',
  'expenses:categories' => 'Categories',
  'expenses:add_supplier' => 'Afegeix Proveïdor',
  'expenses:edit_supplier' => 'Editar Proveïdor',
  'expenses:add_category' => 'Afegir categoria',
  'expenses:edit_category' => 'Editar categories',
  'expenses:parent_category' => 'Categoria superior',
  'expenses:filter' => 'Filtrar despeses',
  'expenses:start_date' => 'Data d\'inici',
  'expenses:end_date' => 'Data de termini',
  'transactions:paymentcancelled' => 'Pagament cancel·lat',
  'transactions:extrapaymentcancelled' => 'El pagament ha estat cancel·lat.',
  'transactions:paymentreceived' => 'Pagament rebut!',
  'transactions:fee_applied' => 'Com :1 imposa una quota per transacció, hem agregat un recàrrec de :2%.',
  'transactions:orderbeingprocessed' => 'Si us plau esperi, la seva comanda s\'està processant i vostè serà redirigit a la :1 pàgina.',
  'transactions:ifyouarenotredirected' => 'Si no se\'l redirigeix automàticament a :1 en 5 segons...',
  'transactions:thankyouforyourpayment' => 'Gràcies pel seu pagament. Rebrà un rebut per correu electrònic en breu.',
  'transactions:ifyouhavefilesyouwillgetanemail' => 'Si té arxius en espera, rebrà un correu electrònic amb un enllaç per a descarregar-los en breu.',
  'transactions:ifyoudonotreceiveemail' => 'Si no rep un correu electrònic dins d\'una hora, si us plau poseu-vos en contacte amb :1',
  'timesheet:taskname' => 'Nom de la tasca',
  'timesheet:starttime' => 'Hora d\'inici',
  'timesheet:endtime' => 'Hora de termini',
  'timesheet:timeframe' => 'Període de temps',
  'timesheet:duration' => 'Durada',
  'timesheet:date' => 'Data',
  'timesheet:forproject' => 'Hores per al projecte ":1"',
  'timesheet:timesheet' => 'Hores',
  'timesheet:for' => 'Hores per a:',
  'timesheet:totalbillable' => 'Total d\'hores facturables',
  'timesheet:view_pdf' => 'Veure hores',
  'timesheet:user' => 'Usuari',
  'timesheet:entries' => 'Entrades',
  'timesheet:no_entries' => 'No hi ha entrades de temps.',
  'tickets:all_tickets' => 'Tiquets de suport',
  'tickets:support_tickets' => 'Tiquets de suport',
  'tickets:pending' => 'Pendents',
  'tickets:open' => 'Oberts',
  'tickets:resolved' => 'Resolts',
  'tickets:closed' => 'Tancats',
  'tickets:respond' => 'Respondre tiquet',
  'tickets:ticket_options' => 'Opcions de tiquet',
  'tickets:attachment' => 'Adjunts',
  'tickets:updated_status' => 'L\'estat del tiquet :1 ha estat actualitzat a :2',
  'tickets:add_a_new_ticket' => 'Afegir un tiquet',
  'tickets:create_a_new_ticket' => 'Crea nou tiquet',
  'tickets:add_ticket' => 'Afegir tiquet',
  'tickets:assign_to_user' => 'Assignar usuari',
  'tickets:select_client' => 'Tria client',
  'tickets:ticket_subject' => 'Assumpte del tiquet',
  'tickets:ticket_message' => 'Missatge del tiquet',
  'tickets:ticket_priority' => 'Prioritat del tiquet',
  'tickets:ticket_status' => 'Estat del tiquet',
  'tickets:no_priority' => '-- Sense prioritat --',
  'tickets:no_status' => '-- Sense estat --',
  'tickets:no_posts' => 'Sense missatge.',
  'frontend:hithere' => 'Hola!',
  'frontend:followthemaillinkdude' => 'Per veure la teva factura has de fer clic a l\'enllaç complet enviat al correu electrònic. Per exemple, :1.',
  'frontend:contactadminforassistance' => 'Si us plau fes això o contacta a :1 al :2 per a ajuda',
  'settings:task_statuses' => 'Estats de tasques',
  'settings:ticket_statuses' => 'Estats de tiquets',
  'settings:ticket_priorities' => 'Prioritats de tiquets',
  'settings:background_color' => 'Color de fons',
  'settings:text_color' => 'Color de text',
  'settings:text_shadow' => 'Ombra de text',
  'settings:box_shadow' => 'Ombra de caixa',
  'settings:default_rate' => 'Valor per defecte',
  'settings:allowed_extensions' => 'Extensions de pujada permeses',
  'settings:comma_separated' => 'separades per comes',
  'settings:pdf_page_size' => 'Mida de pàgina PDF',
  'settings:default_invoice_notes' => 'Notes de factura per defecte',
  'settings:default_invoice_title' => 'Títol de factura per defecte',
  'settings:default_invoice_due_date' => 'Data de venciment de factura per defecte',
  'settings:autosave_proposals' => 'Auto guardat de propostes',
  'settings:default_invoice_due_date_explain' => 'dies després que la factura ha estat creada. Si no vols una data per defecte, deixar-ho en blanc.',
  'settings:testemailsettings' => 'Ajustos per al correu de proves',
  'settings:include_remittance_slip' => 'Tiquet de remesa',
  'settings:include_remittance_slip_explain' => 'Si està marcat, els PDFs de les factures inclouran despeses.',
  'settings:items_per_page' => 'Ítems per pàgina',
  'settings:items_per_page_explain' => 'Nombre d\'ítems (factures/pressupostos/propostes/projectes/tasques) a mostrar per pàgina.',
  'settings:send_x_days_before' => '"enviar X dies abans" per defecte',
  'settings:send_x_days_before_explain' => 'Nombre predeterminat de dies abans d\'una factura recurrent s\'ha d\'enviar a un client.',
  'settings:file_to_import' => 'Arxiu a importar',
  'settings:file_should_be_csv' => 'Pancake processarà automàticament el seu arxiu i importarà tot el que conté. Si Pancake és incapaç de processar el seu arxiu, aquest es ho farà saber, i se li donarà l\'opció de enviar-nos alguna informació per ajudar-lo a importar el fitxer.',
  'settings:importnow' => 'Importar ara!',
  'settings:whatimporting' => 'Què estàs important?',
  'settings:whatexporting' => 'Què estàs exportant?',
  'settings:nouploadedimportfile' => 'No has pujat un arxiu per importar.',
  'settings:import' => 'Importar',
  'settings:importedclients' => 'Importats :1 clients correctament.',
  'settings:importedprojects' => 'Importats :1 projectes correctament.',
  'settings:importedusers' => 'Importats :1 usuaris correctament.',
  'settings:importedinvoices' => 'Importats :1 factures correctament.',
  'settings:importedtasks' => 'Importats :1 tasques correctament.',
  'settings:importedestimates' => 'Importats :1 pressupostos correctament.',
  'settings:importedtime_entries' => 'Importades :1 entrades temporals correctament.',
  'settings:xwereduplicates' => ':1 eren duplicades i s\'han ignorat.',
  'settings:import_desc' => 'Importar informació a Pancake.',
  'settings:export' => 'Exportar',
  'settings:exportnow' => 'Exportar ara!',
  'settings:importexport' => 'Importar / Exportar',
  'settings:removelogo' => 'Eliminar Logo',
  'settings:wrong_license_key' => 'La clau de llicència que heu introduït no és vàlida.',
  'settings:noopenssl' => 'El vostre servidor de PHP no té configurat OpenSSL, el que significa que no pot utilitzar Gmail o Google Apps per enviar correus. Posi\'s en contacte amb el seu hosting i fes-los saber que requereix OpenSSL.',
  'settings:logoremoved' => 'Logo eliminat amb èxit!',
  'settings:save' => 'Desar configuracions',
  'settings:logodimensions' => 'El logo pot ser pujat en qualsevol mida i serà redimensionat automàticament.',
  'settings:logoformatsallowed' => 'BMP, PNG, JPG (JPEG) i GIF estan permesos.',
  'settings:ftp_user' => 'Usuari FTP',
  'settings:ftp_pass' => 'Contrasenya FTP ',
  'settings:ftp_path' => 'Ruta FTP',
  'settings:ftp_port' => 'Port FTP',
  'settings:ftp_pasv' => 'Mode passiu?',
  'settings:nophpupdates' => 'A causa de la forma en què el seu servidor està configurat, haurà d\'introduir les dades del FTP perquè Pancake pugui actualitzar-se. Les dades s\'usen internament per Pancake i mai es transmeten a ningú.',
  'settings:ftp_host' => 'Servidor de FTP',
  'settings:uptodate' => 'Pancake està actualitzat (:1)',
  'settings:newversionavailable' => 'Hi ha una nova versió de Pancake Disponible (:1)!',
  'settings:updatenow' => 'Actualitzar ara!',
  'settings:checkforupdates' => 'Comprovar actualitzacions',
  'settings:youneedtoconfigurefirst' => 'La vostra Pancake encara no està configurat per actualitzar-se. Si us plau, introdueixi les dades de FTP a continuació, i premi "Desar la configuració". <br /> Pancake s\'actualitzarà automàticament.',
  'settings:general' => 'General',
  'settings:emails' => 'Correus',
  'settings:taxes' => 'Impostos',
  'settings:currencies' => 'Monedes',
  'settings:branding' => 'Marca',
  'settings:payment_methods' => 'Pagaments',
  'settings:feeds' => 'Fonts',
  'settings:api_keys' => 'Claus API',
  'settings:time_entry_times' => 'Entrada de temps',
  'settings:include_dates_and_times_in_line_items' => 'Inclou dates i hores en les descripcions d\'articles de línia "entrada de temps".',
  'settings:when_generating_invoice' => 'Quan es generin factures, utilitzar una línia per ítem',
  'settings:use_utf8_font' => 'Utilitzar una tipografia UTF-8 a PDFs',
  'settings:use_utf8_font_explanation' => 'Feu servir aquesta opció si les tipografies es fan malbé en els seus arxius PDF.',
  'settings:pdf_attachments' => 'PDF Adjunts',
  'settings:pdf_attachments_explanation' => 'Si està marcat, Pancake adjuntarà el PDF corresponent a la factura, pressupost o proposta als correus electrònics.',
  'settings:site_name' => 'Nom del lloc',
  'settings:language' => 'Llenguatge',
  'settings:timezone' => 'Fus horari',
  'settings:notify_email' => 'Correu de notificació',
  'settings:currency' => 'Moneda',
  'settings:theme' => 'Tema de front',
  'settings:admin_theme' => 'Tema d\'admin',
  'settings:admin_name' => 'Nom d\'admin',
  'settings:date_format' => 'Format de data',
  'settings:time_format' => 'Format d\'hora',
  'settings:task_time_interval' => 'Arrodoniment d\'entrada temporal (Deixar en blanc per no arrodonir)',
  'settings:task_time_interval_description' => '(ex 00:30 o 0,5 - totes les entrades de temps s\'arrodoneixen a la més propera dotze i mitja quan es factura per ells en una factura.)',
  'settings:mailing_address' => 'Direcció de correus',
  'settings:default_subject' => 'Assumpte predeterminat',
  'settings:default_contents' => 'Missatge de l\'assumpte',
  'settings:new_estimate' => 'Nova estimació',
  'settings:new_invoice' => 'Nova factura',
  'settings:new_proposal' => 'Nou pressupost',
  'settings:paid_notification' => 'Notificació de pagament',
  'settings:payment_receipt' => 'Rebut de pagament',
  'settings:new_ticket' => 'Nou tiquet',
  'settings:ticket_invoice' => 'Nou tiquet de factura',
  'settings:ticket_updated' => 'Tiquet actualitzat',
  'settings:ticket_status_updated' => 'Estat del tiquet actualitzat',
  'settings:logo' => 'El seu logo',
  'settings:frontend_css' => 'CSS personalitzat per Frontend',
  'settings:backend_css' => 'CSS personalitzat per Backend',
  'settings:rss_password' => 'Password del RSS',
  'settings:default_feeds' => 'Fonts per defecte',
  'settings:cron_job_feed' => 'Treball de servidor configurat per horari',
  'settings:feed_generator' => 'Generador de fonts',
  'settings:your_link' => 'El seu enllaç',
  'settings:bcc' => 'CCO',
  'settings:automaticallybccclientemail' => 'Automàticament enviar una còpia al client de tots els emails al mail de notificació (definit més endavant)',
  'settings:api_note' => 'Nom / Nota',
  'settings:api_key' => 'Clau',
  'settings:tax_name' => 'Nom de l\'impost',
  'settings:tax_value' => 'Valor',
  'settings:tax_reg' => 'Registre / codi',
  'settings:add_tax' => 'Afegir un altre impost',
  'settings:currency_name' => 'Nom de la monedaa',
  'settings:currency_code' => 'Codi de la moneda',
  'settings:exchange_rate' => 'Tipus de canvi',
  'settings:add_currency' => 'Afegir una altra moneda',
  'update:ifyourenotsurecontactus' => 'Si no està segur de què fer, <a href=\'http://pancakeapp.com/forums/newtopic/2/\'> comenci un nou tema de suport tècnic als fòrums</a>.',
  'update:youmodified' => 'Va modificar',
  'update:youdeleted' => 'Va eliminar',
  'update:loadingpleasewait' => 'Carregant, si us plau esperi...',
  'update:errordownloading' => 'Una actualització de Pancake està disponible, però hi ha problemes per descarregar-la.',
  'update:herearestepstofix' => 'Aquí té una llista amb alguns passos que pot provar per tractar de solucionar-ho:',
  'update:makesureuploadsiswritable' => 'Verifiqui que la carpeta de pujades tingui permisos d\'escriptura (CHMOD 0777).',
  'update:deletepancakesystemupdate' => 'Eliminar la carpeta pancake-update-system dins de la carpeta uploads, i tots els seus continguts.',
  'update:loadpancakeagain' => 'Carregui Pancake novament. Si l\'error persisteix, canviar el propietari de la carpeta Pancake (chown) perquè coincideixi amb l\'usuari del servidor web. Si no pot fer això, o no sap com, si us plau envii un correu electrònic a support@pancakeapp.com, i l\'ajudarem.',
  'update:whatschanged' => 'Què hi ha de nou a :1',
  'update:ftp_conn' => 'Pancake no pot connectar amb el servidor FTP.',
  'update:ftp_login' => 'Pancake no pot autenticar via FTP (usuari/password erroni?).',
  'update:ftp_chdir' => 'Pancake no pot configurar la ruta FTP (la ruta probablement no existeix).',
  'update:ftp_no_uploads' => 'Pancake no pot obtenir permisos per pujar arxius via FTP.',
  'update:ftp_indexwrong' => 'La ruta FTP que heu introduït és incorrecta. Hauria de ser la ruta on està instal·lat Pancake.',
  'update:ftp_indexnotfound' => 'La ruta FTP que heu introduït és incorrecta. Hauria de ser la ruta on està instal·lat Pancake.',
  'update:update_conflict' => 'Ha modificat alguns arxius de la darrera actualització. Per tal de salvaguardar les personalitzacions, aquí hi ha una llista dels arxius que s\'han modificat, que entren en conflicte amb l\'última actualització.',
  'update:update_no_perms' => 'Pancake no té prou permisos per a actualitzar-se, ni té accés a un compte FTP des del qual ho pugui fer. L\'actualització no pot continuar.',
  'update:review_files' => 'Si us plau revisi els següents fitxers i faci còpies de seguretat. Quan el procés acabi, haurà de reintegrar els seus canvis als nous fitxers. Si us plau, no substitueixi simplement els nous fitxers amb els seus, ja que podria fer fallar Pancake.',
  'update:internetissues' => 'Pancake no pot connectar a Internet.',
  'update:pancakeneedsinternet' => 'Per a que Pancake funcioni correctament, el seu servidor ha de permetre obtenir certa informació d\'Internet (port 80).',
  'update:maybefirewall' => 'Sembla que el seu servidor està bloquejant Pancake per a obtenir accés d\'Internet. Podria ser un problema del tallafocs. Si us plau contacti amb el seu proveïdor per a ajut. Demani\'ls accés per a PHP :1.',
  'update:nointernetaccess' => 'No hi ha accès a Internet',
  'update:pancakeupdated' => 'Pancake ha estat actualitzat de :1 a :2',
  'partial:partialpayments' => 'Pla de pagaments',
  'partial:totalamounttobepaid' => 'Total a ser pagat pel client',
  'partial:amountlefttobeadded' => 'Suma que falta per ser afegida al pla',
  'partial:amounttoobig' => 'Suma que ha de ser remoguda del pla',
  'partial:noamountneeded' => 'El pla de pagaments està complet.',
  'partial:amount' => 'Suma',
  'partial:add_payment' => 'Afegir pagament',
  'partial:dueon' => 'Venç el',
  'partial:addanother' => 'Afegir un altre pagament',
  'partial:disabledforrecurring' => 'Facturació recurrent està limitada a un sol pagament',
  'partial:paymentdetails' => 'Detalls de pagament',
  'partial:wrongtotal' => 'La suma de totes les parts del seu pla de pagament no coincideix amb la quantitat total de la factura.',
  'partial:problemsaving' => 'S\'ha produït un problema en desar el pla de pagament. Si us plau, torni-ho a provar.',
  'partial:wrongtotalbutsaved' => 'La suma de totes les parts del pla de pagament no coincideix amb la quantitat total que es va facturar. <br /> S\'han guardat els canvis a la factura, però que cal esmenar el pla de pagament',
  'partial:problemsavingbutsaved' => 'S\'ha produït un problema en desar el pla de pagament. Torneu-ho de nou. <br /> S\'han guardat els canvis a la factura, però no en el pla de pagament.',
  'partial:savepaymentdetails' => 'Guardar les dades de pagament',
  'partial:partpaidthanks' => 'Aquesta part de la factura ha estat guardarda, gràcies.',
  'partial:proceedtopayment' => 'Procedir al pagament',
  'partial:topaynowgoto' => 'Per pagar ara, dirigir-se a :1',
  'partial:pay_part_x_now' => 'Pagar part #:1 de la factura ara',
  'partial:dueondate' => 'venç el :1',
  'partial:paymentmethod' => 'Mètode de pagament',
  'partial:paymentdate' => 'Data de pagament',
  'partial:paymentstatus' => 'Estat de pagament',
  'partial:transactionid' => 'ID de transacció',
  'partial:markaspaid' => 'Marcar com a pagat',
  'partial:transactionfee' => 'Impost de transacció',
  'paypal:clickhere' => 'Clic per a procedir',
  'authorize:transaction_key' => 'Clau de transacció',
  'paypal:email' => 'Correu de PayPal',
  'paypal:fee' => 'Impost (%) de Paypal',
  'paypalpro:paypalpro' => 'PayPal Payments Pro (BETA)',
  'paypalpro:viacreditcard' => 'Pagar amb targeta de crèdit',
  'cash:cash' => 'Diners',
  'check:check' => 'Xec',
  'moneyorder:moneyorder' => 'Ordre de pagament',
  'creditcard:creditcard' => 'Targeta de crèdit',
  'banktransfer:banktransfer' => 'Transferència bancària',
  'gateways:errorupdating' => 'Hi ha hagut un error en actualitzar la configuració del mètode de pagament. Si us plau, poseu-vos en contacte amb suport.',
  'gateways:paymentmethods' => 'Mètodes de pagament',
  'gateways:selectpaymentmethod' => 'Seleccionr mètode de pagament',
  'gateways:nogatewayused' => 'Cap mètode utilitzat: la part no ha estat pagada',
  'gateways:completed' => 'Completat',
  'gateways:refunded' => 'Reintegrat',
  'gateways:unpaid' => 'Sense pagar',
  'gateways:paymentrejected' => 'Pagament :1 rebutjat',
  'gateways:pending' => 'Pendent',
  'gateways:returntowebsite' => 'Retornar a :1',
  'gateways:cc_type' => 'Tipus de targeta de crèdit',
  'gateways:cc_number' => 'Nombre de la targeta de crèdit',
  'gateways:cc_exp' => 'Data de venciment',
  'gateways:cc_cardholder' => 'Nom a la targeta',
  'gateways:cc_code' => 'Codi de seguretat',
  'gateways:payment_details' => 'Detalls de pagament',
  'gateways:api_signature' => 'Signatura d\'API',
  'gateways:api_password' => 'Password d\'API ',
  'gateways:api_username' => 'Usuari d\'API',
  'kitchen:edit_comment' => 'Editar comentari',
  'kitchen:add_a_comment' => 'Afegir un comentari',
  'kitchen:kitchen_name' => 'Àrea d\'accés de clients',
  'kitchen:pleaselogin' => 'Si us plau, ingressi la seva contrasenya per accedir a aquest compte',
  'kitchen:nocomments' => 'Cap comentari encara.',
  'kitchen:comment' => 'Comentari',
  'kitchen:comments' => 'Comentaris',
  'kitchen:comments_x' => 'Comentaris (:1)',
  'kitchen:file' => 'Arxiu',
  'kitchen:submitcomment' => 'Afegeix comentari',
  'kitchen:attachment' => 'Adjunt',
  'kitchen:saidon' => 'dit el :1, a las :2',
  'kitchen:subjectinvoice' => 'Nou comentari per a Factura #',
  'kitchen:subjectestimate' => 'Nou comentari per a Pressupost #',
  'kitchen:subjectproject' => 'Nou comentari per a Projecte:',
  'kitchen:subjecttask' => 'Nou comentari per a Tasca:',
  'kitchen:subjectproposal' => 'Nou comentari per a Proposta:',
  'kitchen:backtodashboard' => 'Tornar al panell de control',
  'kitchen:client_welcome' => 'Accés de client per a:',
  'kitchen:urltosend' => 'URL d\'accés al client ',
  'kitchen:nopassphrase' => 'Actualment, el client no té contrasenya, això vol dir que només l\'accés a aquesta url és tot el que es necessita per veure l\'àrea del client. Si vols assegurar l\'àrea amb una contrasenya, si us plau editi aquest client i estableixi una contrasenya.',
  'kitchen:passphraseset' => 'Aquest client ha establert una contrasenya',
  'kitchen:passphrase' => 'Contrasenya',
  'kitchen:description' => 'Aquesta és la URL per enviar al seu client perquè pugui accedir a l\'àrea de clients, aquí podrà veure projectes i factures que hagi definit com visibles per a ell.',
  'kitchen:people_in_discussion' => 'Persones conversant',
  'kitchen:latest_invoice' => 'Última factura',
  'kitchen:unpaid_balance' => 'Balanç sense pagar :1',
  'kitchen:total_paid_to_date' => 'Total pagat a la data: :1',
  'store:store' => 'Botiga',
  'store:buy' => 'Comprar ($:1)',
  'store:update' => 'Actualitzar',
  'store:install' => 'Instal·lar',
  'store:settings' => 'Configuració',
  'store:already_bought' => 'Ja havies comprat aquest ítem!',
  'store:installed_successfully' => 'Heu instal·lat :1 :2 correctament.',
  'store:plugin' => 'Plugin',
  'store:payment_gateway' => 'Passarel·la de Pagament',
  'store:frontend_theme' => 'Tema de Frontend',
  'store:backend_theme' => 'Tema de Backend',
  'store:unknown' => 'Desconegut',
  'store:updatestoreitems' => 'Actualitza els elements de botiga',
  'store:download_free' => 'Descarregar (gratuït)',
  'store:error1000' => 'El token d\'autorització ja no és vàlid. Vostè haurà d\'introduir les seves dades de pagament a pancakeapp.com un cop més.',
  'store:error1001' => 'Vosté ja havia comprat aquest ítem a la botiga!',
  'store:error1002' => 'ha tingut lloc un problema mentre tractàvem de carregar l\'ítem a la seva targeta de crèdit. Si us plau, intenti-ho novament.',
  'store:error1003' => 'Ha realitzat una petició invàlida.',
  'email_templates:new_invoice' => 'Nova factura',
  'email_templates:new_estimate' => 'Nou pressupost',
  'email_templates:new_proposal' => 'Nova proposta',
  'email_templates:invoice_payment_notification_for_admin' => 'Notificació de pagament (enviada al admin)',
  'email_templates:invoice_payment_notification_for_client' => 'Notificació de rebut de pagament (enviada al client)',
  'email_templates:new_ticket' => 'Nou tiquet',
  'email_templates:new_ticket_invoice' => 'Nova factura de tiquet',
  'email_templates:ticket_updated' => 'Notificació d\'actualització de tiquet',
  'email_templates:ticket_status_updated' => 'Notificació d\'actualització d\'estat de tiquet',
  'email_templates:assigned_to_task' => 'Notificació d\'assignació de tasca',
  'email_templates:assigned_to_milestone' => 'Notificació d\'assignació de fita',
  'email_templates:new_comment' => 'Nova notificació de comentari',
  'global:timer_app' => 'Aplicació de temps',
  'invoices:lastreoccurrence' => 'Última re-ocurrència: :1',
  'invoices:converted_to_estimate' => 'Factura #:1 convertida en pressupost.',
  'global:converttoestimate' => 'Convertir a pressupost',
  'tickets:view_archived' => 'Veure tiquets arxivats',
  'tickets:view_unarchived' => 'Veure tiquets actius',
  'tickets:archiving_ticket' => 'Arxivant tiquet',
  'tickets:unarchiving_ticket' => 'Desarxivar tiquet',
  'tickets:unknown_error_ticket_not_altered' => 'Ha ocorregut un error. El tiquet no ha estat alterat.',
  'tasks:starting_timer' => 'Començant temporitzador',
  'tasks:stopping_timer' => 'Aturant temporitzador',
  'global:all_comments' => 'Tots els comentaris',
  'dashboard:view_all_comments' => 'Mostra tots els comentaris',
  'dashboard:latest_comments' => 'Últims comentaris',
  'dashboard:written_by' => 'Escrit per :1 el :2',
  'dashboard:client_activity' => 'Activitat del client',
  'dashboard:view_all_client_activity' => 'Veure tota l\'activitat del client',
  'dashboard:team_activity' => 'Activitat de l\'equip',
  'dashboard:view_all_team_activity' => 'Veure tota l\'activitat de l\'equip',
  'dashboard:my_tasks' => 'Les meves tasques',
  'dashboard:view_all_my_tasks' => 'Veure totes les meves tasques',
  'dashboard:what_the_team_is_working_on' => 'En el que l\'equip està treballant',
  'global:save_milestone' => 'Desar fita',
  'global:save_task' => 'Desar tasca',
  'global:private_comment' => 'Aquest comentari és privat, el teu client no ho pot veure.',
  'global:clients_cant_see_private' => 'Els clients no poden veure comentaris privats.',
  'global:is_private' => 'Privat?',
  'tickets:disable_client' => '-- Deshabilitar tiquets de suport --',
  'global:css' => 'CSS personalitzat',
  'global:js' => 'JavaScript personalitzat',
  'global:js_explanation' => 'Pot utilitzar jQuery com vulgui. El seu codi serà afegit just abans de l\'etiqueta &lt;/body&gt;.',
  'settings:frontend_js' => 'JavaScript personalitzat per al Frontend',
  'settings:backend_js' => 'JavaScript personalitzat per al Backend',
  'proposals:estimate_number_and_amount' => 'Pressupost #:1 (:2)',
  'clients:delete' => 'Eliminar client',
  'global:nolongerexists' => '[JA NO EXISTEIX]',
  'global:billed_amount' => 'Quantitat facturada',
  'global:unbilled_amount' => 'Quantitat sense facturar',
  'global:is_billed' => 'Facturat?',
  'settings:year_start' => 'Començament de l\'any fiscal',
  'dashboard:since_explanation' => 'Des de l\' :1',
  'export:invoices_csv' => 'Factures (CSV)',
  'projects:createdtemplate' => 'Plantilla de projecte creada. Ara pots crear projectes basats en aquesta plantilla.',
  'projects:delete_template' => 'Eliminar plantilla',
  'projects:deleted_template' => 'Èxit! Plantilla eliminada.',
  'export:expenses_csv' => 'Despeses (CSV)',
  'export:clients_csv' => 'Clients (CSV)',
  'projects:expense_date' => 'Data de despeses',
  'clients:can_create_support_tickets' => 'Permetre al client per crear tiquets de suport?',
  'tickets:submit_new' => 'Envia tiquet',
  'global:cancel' => 'Cancel·lar',
  'global:timers' => 'Comptadors temporals',
  'global:more' => 'Més',
  'global:search' => 'Cercar',
  'authorize:api_login_id' => 'API Login ID',
  'authorize:api_login_id_description' => 'Podeu trobar això a Authorize.net, sota Account> API Login ID and Transaction Key.',
  'authorize:md5_hash' => 'MD5-Hash',
  'authorize:md5_hash_description' => 'Per defecte, aquest és el seu ID d\'accés de l\'API. Pot canviar això a Authorize.net, sota Account > MD5-Hash. Si veu  \'Hash Value Set: No\', deixi això en blanc.',
  'transactions:paymentfailed' => 'El pagament ha fallat ',
  'transactions:extrapaymentfailed' => 'Ha ocorregut un problema inesperat en intentar processar el pagament. Si us plau, poseu-vos en contacte amb :1 a :2 per a assistència.',
  'projects:tracked' => 'Agregat a l\'historial',
  'invoices:partially_paid' => 'Parcialment',
  'global:projects_ommitted' => ':1 projectes no mostrats',
  'global:tasks_ommitted' => ':1 tasques no mostrades',
  'login:username_email' => 'Usuari / Correu',
  'settings:when_new_updates_are_available' => 'Quan hi ha noves actualitzacions disponibles',
  'settings:dont_install_just_notify_me' => 'No instal·lar, només notificar-me',
  'settings:install_automatically' => 'Instal·lar automàticament',
  'settings:loading_update_details' => 'Carregant detalls de l\'actualització... Això pot tardar un minut o dos. Refresca en qualsevol moment.',
  'settings:updating_please_wait' => 'Actualitzant, si us plau, esperi. Aquesta pàgina es refescarà automàticament quan l\'actualització hagi estat realitzada.',
  'settings:will_have_to_overwrite_single_file' => 'Pancake sobreescriurà 1 arxiu que ha modificat manualment!',
  'settings:will_have_to_overwrite_multiple_files' => 'Pancake sobreescriurà :1 arxius que has modificat manualment!',
  'settings:checking_for_updates' => 'Revisant si hi ha actualitzacions disponibles, si us plau, esperi. Aquesta pàgina es refescará automàticament.',
  'settings:description' => 'Guardi les seves configuracions actualitzades abans de canviar de pestanya o abandonar la pàgina.',
  'settings:business_identities' => 'Identitats de negoci',
  'settings:business_name' => 'Nom del negoci',
  'settings:new_business' => 'Nou negoci',
  'settings:business_identity' => 'Identitat del negoci',
  'settings:business_identity_explanation' => 'El seu client veurà la identitat de l\'empresa per sobre de tots els seus correus electrònics, arxius PDF i pàgines',
  'settings:have_been_updated' => 'Les configuracions han estat actualitzades.',
  'tasks:all' => 'Totes les tasques',
  'projects:progress' => 'Progrés',
  'expenses:name' => 'Nom de la despesa',
  'tasks:add_hours_to' => 'Afegir hores a :1',
  'global:today' => 'Avui',
  'global:yesterday' => 'Ahir',
  'global:other' => 'Un altre',
  'global:now' => 'Ara',
  'timesheet:view_for_clients' => 'Veure llistat d\'hores treballades (per a clients)',
  'global:not_billed_yet' => 'No cobrades encara',
  'tasks:total_logged_time' => 'Temps total anotat a la plataforma',
  'global:biweekly' => 'Cada dues setmanes',
  'settings:default_task_due_date' => 'Data de venciment de tasques per defecte',
  'settings:default_task_due_date_explain' => 'dies després que la tasca es crea. Si no vol una data predeterminada, deixar el camp buit.',
  'global:timesheets' => 'Fulles de temps',
  'timesheets:all_users' => 'Tots els usuaris',
  'timesheets:todays' => 'D\'avui',
  'timesheets:rounded_time' => 'Arrodonit al :1 més proper',
  'timesheets:there_are_no_time_entries' => 'No hi ha entrades de temps de visualització per aquest interval.',
  'expenses:sort_or_filter' => 'Ordenar/Filtrar Despeses',
  'global:there_is_no_activity' => 'No hi ha activitat d\'equip per mostrar.',
  'global:there_are_no_tasks_assigned_to_you' => 'No hi té tasques assignades.',
  'global:sort_by' => 'Ordenar per',
  'expenses:show' => 'Mostrar despeses',
  'global:sort_order' => 'Ordre de classificació',
  'global:desc' => 'Descendent(A-Z)',
  'settings:no_tax' => 'Sense impostos',
  'global:asc' => 'Ascendent (A-Z)',
  'settings:default_taxes' => 'Impostos per defecte',
  'global:tax' => 'Impost',
  'global:youarenotallowed' => 'No té permès accedir a aquesta pàgina.',
  'settings:tax_compound' => 'Compost?',
  'settings:billing_email' => 'Correu electrònic associat al compte de facturació',
  'settings:brand_name' => 'Nom de la Marca',
  'settings:brand_name_explanation' => 'Aquest és el nom que vol que els seus clients vegin. Es mostrarà a tot arreu, excepte a les factures.',
  'settings:show_name_along_with_logo' => 'Mostrar el nom de la seva marca al costat del seu logotip?',
  'settings:admin_name_explanation' => 'Per defecte, aquest apareix al final dels correus electrònics que envii als clients.',
  'settings:billing_email_explanation' => 'Aquesta és l\'adreça utilitzada com "remitent" per als correus electrònics de Factures, Estimacions i Propostes.',
  'dashboard:snapshot' => 'Instantània',
  'invoices:frequency' => 'Freqüència',
  'settings:business_name_explanation' => 'Aquest és el nom legal del seu negoci. Es mostrarà a les seves factures.',
  'dashboard:your_projects' => 'Els seus projectes',
  'invoices:send' => 'Enviar',
  'invoices:auto_send' => 'Enviar automàticament?',
  'dashboard:today' => 'Avui',
  'settings:always_https' => 'Forçar HTTPS?',
  'settings:notify_email_explanation' => 'Aquesta és la direcció "Des de" utilitzada per a les notificacions de comentaris i per tiquets de suport.',
  'invoices:days_before_invoice_is_due' => 'dies abans de factura és degut a',
  'settings:always_https_explanation' => 'Això farà que Pancake es carregui sempre a través d\'HTTPS. Utilitzeu això només si té un certificat SSL instal·lat i pot accedir a Pancake a través d\'HTTPS.',
  'invoices:mail_to' => 'Enviar a',
  'invoices:cannot_change_recurrences' => 'No pot canviar la configuració de repetició d\'una factura que al seu torn és la repetició d\'una altra factura.',
  'clients:you_cannot_send' => 'No podeu enviar a aquest client els seus detalls de l\'àrea de clients per correu electrònic perquè aquest client no té una adreça de correu electrònic.',
  'email_templates:client_area_details' => 'Detalls de l\'Àrea de Clients',
  'invoices:discount' => 'Descompte',
  'clients:send_client_area_email' => 'Enviar detalls de l\'Àrea de clients',
  'settings:remittance_slip' => 'Cobrament',
  'invoices:discount_explain' => 'Afegir % per als percentatges.',
  'credit_notes:edit_credit_note' => 'Editar Nota de Crèdit #:1',
  'credit_notes:create_credit_note' => 'Crear una Nota de Crèdit',
  'global:credit_notes' => 'Notes de Crèdit',
  'global:credit_note' => 'Nota de crèdit',
  'credit_notes:alltitle' => 'Totes les Notes de Crèdit',
  'credit_notes:edit' => 'Editar la nota de crèdit',
  'credit_notes:delete_message' => 'Esteu segur que voleu suprimir aquesta nota de crèdit?',
  'credit_notes:no_credit_notes' => 'Vosté no té Notes de Crèdit.',
  'credit_notes:create' => 'Crear Nota de Crèdit',
  'credit_notes:delete_title' => 'Eliminar aquesta nota de crèdit?',
  'credit_notes:nocredit_notesforthefilteredclient' => 'Vosté no té notes de crèdit per a :1.',
  'credit_notes:send_now_title' => 'Enviar la nota de crèdit ara?',
  'credit_notes:no_credit_notes_body' => 'Hauria d\'apuntar-se a això! Li agradaria crear una ara?',
  'credit_notes:send_now' => 'Enviar la nota de crèdit',
  'credit_notes:credit_note_number' => 'Nota de Crèdit #:1',
  'credit_notes:credit_note_date' => 'Data de la nota de crèdit',
  'credit_notes:preview' => 'Previsualitzar la nota de crèdit',
  'email_templates:new_credit_note' => 'Nova nota de crèdit',
  'clients:view' => 'Veure client',
  'credit_notes:duplicated' => 'La nota de crèdit està duplicada #:1. El número de la nova nota de crèdit és #:2.',
  'global:success' => 'Èxit!',
  'clients:credit_balance_currently' => 'Balanç de crèdit (actualment :1)',
  'invoices:make_bulk_payment' => 'Fes pagaments múltiples',
  'credit_notes:send_now_body' => 'Ompli el següent formulari i li lliurarem aquesta nota de crèdit.',
  'invoices:x_invoices' => ':1 factures',
  'invoices:amount_to_pay' => 'Quantitat per marcar com a pagada',
  'credit_notes:addedconf' => 'Ha afegit la nota de crèdit # <strong>:1</strong>, per un total de <strong>:2</strong> (:3 amb impostos) per :4:5.',
  'invoices:send_bulk_payment_notification' => 'Enviar notificacions de correus electrònics dels pagaments al client?',
  'global:credit_balance' => 'Balanç de crèdit',
  'credit_notes:client_viewed' => ':1 va veure <a href=":2">nota de crèdit #:3</a> el :4',
  'invoices:bulk_payment_added' => 'Els pagaments s\'han afegit amb èxit.',
  'invoices:send_payment_notification' => 'Envia una notificació del pagament mitjançant correu electrònic al client?',
  'invoices:specify_bulk_payment_details' => 'Especifiqueu els detalls dels pagaments del seu client, i seleccioneu les factures a les quals s\'apliquen els pagaments.',
  'clients:has_no_unpaid_invoices' => ':1 no té factures sense pagar.',
  'credit_notes:view' => 'Veure nota d\'abonament.',
  'invoices:store_bulk_payment' => 'Desar Diversos Pagaments',
  'settings:ticket_status_for_sending_invoice' => 'Estat dels tiquets per a la facturació.',
  'expenses:added' => 'La despesa ha estat afegida amb èxit.',
  'settings:ticket_status_for_sending_invoice_description' => 'Quan un tiquet pagat s\'actualitza a aquest estat, una factura es generarà automàticament i serà enviada al client.',
  'tickets:ticket_number' => 'Tiquet #:1',
  'global:incorrect_login' => 'La combinació de nom d\'usuari/contrasenya que ha introduït no és vàlida.',
  'settings:hide_tax_column' => 'Amagar columna d\'impostos?',
  'global:error_submitting_ajax' => 'S\'ha produït un error desconegut tractant d\'enviar aquest formulari. Si us plau, intenti-ho més tard. Si l\'error persisteix, si us plau, comenceu un tiquet de suport gratuït a pancakeapp.com.',
  'invoices:send_to_client' => 'Envia Factura via correu electrònic al client',
  'invoices:sub_total_after_discounts' => 'Subtotal (després dels descomptes)',
  'global:beforeunload' => 'Esteu a punt de sortir d\'aquesta pàgina. Si ho fa, es perdran totes les dades que has introduït fins ara. Està segur que vol sortir d\'aquesta pàgina?',
  'global:unanswered' => 'Sense resposta',
  'global:accepted' => 'Acceptat',
  'tickets:not_yet_generated' => 'Factura no generada encara',
  'estimates:accepted' => 'Acceptacions estimades',
  'store:error1004' => 'S\'ha produït un error desconegut en tractar d\'adquirir aquest article. Torneu-ho a intentar de nou més tard.',
  'settings:never_send_ticket_invoices_automatically' => '- Mai enviï factures automàticament',
  'clients:update_balance' => 'Actualitzar balanç de crèdit',
  'estimates:unanswered' => 'Estimacions sense resposta',
  'global:appendtoproject' => 'Convertir en tasques per a ":1"',
  'items:percentage_discount' => 'Descompte (%)',
  'global:rejected' => 'Rebutjat',
  'estimates:rejected' => 'Rebutjos estimats',
  'items:fixed_discount' => 'Descompte (:1)',
  'clients:add_custom_field' => 'Afegir un altre camp personalitzat',
  'clients:balance_updated' => 'Èxit! El saldo de crèdit de client s\'ha actualitzat amb èxit.',
  'invoices:discount_percentage' => 'Descompte (:1%)',
  'expenses:attach_receipt' => 'Adjuntar Rebut (Mida màxima: :1)',
  'estimates:send_to_client' => 'Correu electrònic estimat del client.',
  'settings:hide_tax_column_explanation' => 'Això ocultarà la columna d\'impostos a les factures que no tenen informació fiscal.',
  'clients:no_amount_specified' => 'No heu especificat una quantitat.',
  'clients:tax_registration_number' => ':1 Nombre / ID',
  'expenses:receipt' => 'Rebut',
  'global:triennially' => 'Triennalment',
  'invoices:pancake_will_automatically_change_is_viewable' => 'Això canviarà a "sí" automàticament quan s\'enviï la factura al client per correu electrònic.',
  'expenses:category_added' => 'Èxit! La categoria de despeses ha estat creada satisfactòriament.',
  'clients:what_do_you_want_to_do' => 'Què vol fer?',
  'expenses:no_receipt' => 'Sense rebut',
  'estimates:appended' => 'Conversió estimada #:1 en tasques de ":2".',
  'tickets:invoice_will_be_generated' => 'Una factura de :1 per a aquest tiquet es generarà quan l\'estat del tiquet canviï a ":2".',
  'emailtemplates:content' => 'Contingut del correu electrònic',
  'reports:verb_created' => 'Creat',
  'reports:verb_paid' => 'Pagat',
  'reports:verb_from_to' => ':1 des de :2 a :3',
  'reports:payments' => 'Pagaments',
  'expenses:edited' => 'Èxit! La despesa s\'ha editat correctament.',
  'dashboard:upcoming_invoices' => 'Properes factures',
  'error:unknown_error_reporting' => 'Hi ha hagut un error desconegut. Si us plau, informi d\'aquest error manualment.',
  'error:sending_details' => 'Enviant els detalls...',
  'clients:save_balance_alteration' => 'Desar l\'alteració del balanç',
  'settings:errors_and_diagnostics' => 'Errors i Diagnòstics',
  'expenses:expense_receipts' => 'Rebuts de despeses',
  'expenses:no_project_business_expense' => 'Despeses del negoci (No del projecte)',
  'clients:tax_numbers' => 'Número d\'identificació fiscal dels clients / documents d\'identitat',
  'dashboard:there_are_no_upcoming_invoices' => 'No hi ha noves factures per mostrar.',
  'error:subtitle' => 'S\'ha produït un error desconegut.',
  'error:title' => 'Error desconegut',
  'error:already_reported' => 'Aquest error ja s\'ha reportat al suport de Pancake.',
  'error:not_logged_in_intro' => 'Aquests errors es registren automàticament.',
  'error:not_logged_in_extra' => 'Si el problema persisteix, si us plau poseu-vos en contacte amb :1.',
  'expenses:expense_date' => 'Data',
  'clients:custom_fields' => 'Camps personalitzats',
  'errors:report' => 'Informe de l\'error',
  'reports:amount_paid' => 'Import del pagament',
  'errors:subject' => 'Títol erroni',
  'global:once' => 'Una vegada',
  'settings:delete_error' => 'Eliminar error',
  'global:x_times' => ':1 vegades',
  'global:twice' => 'Dues vegades',
  'errors:number_of_occurrences' => 'nombre d\'ocurrències',
  'settings:report_error' => 'Informe de l\'error',
  'error:logged_in_extra' => 'Feu clic aquí per enviar un tiquet de suport gratuït amb els detalls de l\'error a l\'Equip de Suport de Pancake.',
  'global:occurred_times' => 'Hi ha hagut :1',
  'error:reporting' => 'Reportant...',
  'projects:role_delete' => 'Eliminar',
  'error:response_will_be_sent_to_email' => 'Se li notificaran les respostes a {email}.',
  'projects:role_view' => 'Veure',
  'settings:error_reported' => 'Error reportat',
  'error:cannot_send_error_details' => 'No podeu publicar els detalls de l\'error a l\'equip de suport de Pancake perquè no esteu connectat.',
  'projects:role_edit' => 'Editar',
  'projects:role_edit_task' => 'Editar tasca',
  'settings:view_error_details' => 'Mostra detalls de l\'error',
  'clients:noclientbodyfiltered' => 'Cap dels noms dels seus clients comença amb ":1".',
  'error:deleting' => 'Esborrant...',
  'projects:role_track_time' => 'Temps de seguiment',
  'error:no_logged_errors' => 'No té errors registrats.',
  'projects:role_add_milestone' => 'Afegir fita',
  'projects:role_create' => 'Crear',
  'projects.title' => 'Projectes',
  'projects:role_add_task' => 'Afegir tasca',
  'projects.edit.title' => 'Actualitzar projecte',
  'projects.create.title' => 'Crear projecte',
  'tickets:unarchive' => 'Restaurar',
  'global:errors' => 'Errors',
  'projects.button.create' => 'Crear projecte →',
  'projects:role_delete_milestone' => 'Eliminar Fita',
  'projects.label.client' => 'Client:',
  'error:logged_in_intro' => 'Aquests errors s\'emmagatzemen en el panell d\'administració a \'Ajustos > Errors & Diagnòstics\'.',
  'projects.label.description' => 'Descripció:',
  'projects.label.name' => 'Nom:',
  'projects.update.succeeded' => 'El projecte s\'ha actualitzat!',
  'projects.label.is_viewable' => 'Visible a l\'àrea de clients?',
  'projects.delete.title' => 'Esteu segur que voleu suprimir aquest projecte?',
  'projects.label.due_date' => 'Data de venciment:',
  'projects.create.succeeded' => 'El projecte ha estat creat!',
  'times.label.end_time' => 'Hora de finalització:',
  'times.label.start_time' => 'Hora d\'inici:',
  'projects.button.delete' => 'Eliminar projecte →',
  'projects:role_edit_milestone' => 'Editar fita',
  'times.button.create' => 'Afegir Temps →',
  'projects.label.rate' => 'Tarifa per hora:',
  'times.create.title' => 'Afegeix temps',
  'projects:role_delete_task' => 'Eliminar tasca',
  'error:cant_send_email' => 'No es pot enviar el correu electrònic',
  'error:not_enough_disk_space_explanation' => 'El vostre servidor de bases de dades (:1) no té prou espai en disc.',
  'times.create.succeeded' => 'El temps ha estat introduït amb èxit!',
  'error:not_enough_disk_space' => 'No hi ha espai suficient al disc',
  'times.label.notes' => 'Notes:',
  'times.title' => 'Nombre de vegades',
  'times.label.date' => 'data:',
  'tickets:archive' => 'Arxiu',
  'projects.button.edit' => 'Actualitzar el projecte →',
  'times.label.note' => 'Nota:',
  'error:email_settings_not_valid' => 'La configuració del seu correu electrònic no és vàlida.',
  'error:cant_send_email_explanation' => 'Ha especificat que voleu utilitzar Sendmail (:1) per enviar correus electrònics, però no ha estat possible fer-ho. O la ruta a Sendmail és incorrecta, o alguna cosa més ha anat malament.',
  'error:server_error' => 'Error al servidor',
  'error:permissions_not_valid' => 'Hi ha un problema amb els permisos de l\'arxiu al seu servidor.',
  'global:estimates_unsent' => 'No enviat',
  'times.edit.succeeded' => 'L\'hora ha estat editada amb èxit!',
  'error:xcache_extension_broken' => 'El vostre servidor té un problema amb l\'extensió XCache.',
  'error:no_tmp_dir_permissions_explanation' => 'El vostre servidor està configurat de tal manera que no permet a Pancake crear arxius temporals a <code>:1</code>.',
  'invoices:see_payment_schedule' => 'Veure Programa de Pagaments',
  'times.label.task_id' => 'Tasca:',
  'error:page_not_found' => 'Pàgina no trobada',
  'error:cant_send_email_solutions' => 'Si té accés d\'administrador (root) al servidor, heu de tenir sendmail instal·lat i tracti de trobar-lo amb <code>sendmail</code>.',
  'error:not_enough_disk_space_solutions' => 'Si té accés root al servidor de la base de dades, proveu buidant /tmp. Si això no funciona, revisi l\'ús de l\'espai del disc dur en el servidor de base de dades, i tracti d\'alliberar una mica d\'espai al disc dur.',
  'error:page_does_not_exist' => 'La pàgina a la que estava intentant accedir no existeix.',
  'invoices:see_payment_schedule_below' => 'Veure Programa de Pagaments a sota',
  'error:xcache_extension_broken_explanation' => 'Quelcom ha fallat mentre el seu servidor estava tractant de carregar l\'extensió XCache. Això no està relacionat amb Pancake en absolut, però està impedint que s\'executi Pancake.',
  'error:no_tmp_dir_permissions_solutions' => 'Si té accés root al servidor, podeu canviar el paràmetre <code>open_basedir</code> al vostre php.ini perquè <code>:1</code> s\'inclogui a la llista de carpetes permeses.',
  'error:page_does_not_exist_explanation' => 'Estava intentant accedir a :1, pero no existeix. Si aquest error és inesperat, pot informar de l\'error a l\'Equip de Suport de Pancake. El trobarà a \'Ajustes &gt; Errors &amp; Diagnòstics.',
  'projects:no_data_provided' => 'Vosté no ha ingressat cap informació per crear un projecte a partir d\'una plantilla.',
  'error:you_cannot_report_this_error' => 'No es pot informar d\'aquest problema al suport de Pancake, ja que és un problema amb el seu servidor. Si us plau, poseu-vos en contacte amb l\'administrador del servidor sobre aquest problema. Quan ho discuteixi amb ells, digui\'ls:',
  'reports:per_payment_method' => 'per la forma de pagament',
  'settings:importedcredit_notes' => 'Importades amb èxit :1 Notes de Crèdit.',
  'projects:invalid_template' => 'No ha seleccionat una plantilla vàlida per al projecte.',
  'gateways:just_for_logging' => 'Nota: Aquesta forma de pagament no afecta les factures de cap manera. <br/> Està aquí perquè pugui realitzar un seguiment dels pagaments rebuts per :1.',
  'settings:test_email_message' => 'Aquest és un correu electrònic de prova. Si ha rebut això, vol dir que els correus electrònics estan funcionant a Pancake.',
  'settings:sending' => 'Enviant correu electrònic...',
  'kitchen:responses' => 'Respostes',
  'settings:test_email_sent' => 'Enviat al :1 correctament!',
  'expenses:supplier_added' => 'Èxit! El proveïdor ha estat creat correctament.',
  'kitchen:no_tickets_created' => 'No hi ha tiquets creats.',
  'projects:add_new_task' => 'Afegir nova tasca',
  'kitchen:x_responses' => ':1 Respostes',
  'settings:test_email_error_header' => 'Error a l\'enviar missatge de prova',
  'projects:delete_project_template' => 'Eliminar la plantilla del projecte',
  'expenses:category_name' => 'Nom de la categoria',
  'expenses:supplier_name' => 'Nom del proveïdor',
  'settings:send_test_email' => 'Enviar un correu electrònic de prova',
  'items:select_flat_rate' => 'Tarifa Plana',
  'invoices:all_unpaid' => 'Tots sense pagar',
  'settings:test_email_error' => 'S\'ha produït un error en provar d\'enviar el correu electrònic de prova:<br/><br/>:1<br/><br/>Assegureu-vos de que les dades introduïdes són correctes. Si utilitzeu SMTP, assegureu-vos que el port que està intentant usar està obert en el tallafocs del seu servidor.',
  'global:show_hide_deleted' => 'Mostrar / ocultar esborrats',
  'settings:test_email_connection_error' => 'El vostre servidor no pot connectar-se a :1 al port :2. Haurà de posar-se en contacte amb l\'administrador del sistema i permetre aquest port en el tallafocs del seu servidor.<br/><br/>El missatge d\'error ha estat:<br/><br/>:3',
  'settings:test_email_subject' => 'Aquest és un correu electrònic de prova.',
  'expenses:supplier_edited' => 'Correcte! El proveïdor ha estat editat correctament.',
  'error:cant_php_mail_explanation' => 'Ha especificat que vol utilitzar PHP mail () per enviar correus electrònics, però aquest mètode d\'enviament de correu electrònic no està funcionant correctament al seu servidor. Aquest mètode d\'enviament de correu electrònic no requereix configuració, però no es recomana perquè els servidors de correu electrònic no poden verificar qui està enviant el correu. Alguns d\'ells fins i tot marcaran automàticament els seus correus electrònics com a correu brossa. Canvieu les opcions del servidor de correu electrònic en l\'apartat d\'administrador, a "Configuració > Correus electrònics", per a usar una de les opcions SMTP, i si no pot, utilitzi l\'opció Sendmail com a últim recurs. Si cap d\'aquestes opcions funciona, haurà de contactar amb el seu administrador de servidor.',
  'reminders:no_due_date' => 'Sense data de venciment',
  'search:results_for_x' => 'Resultats de cerca per ":1"',
  'expenses:category_edited' => 'Èxit! La categoria ha estat editada correctament.',
  'global:project_task' => 'Tasca',
  'global:ticket' => 'Tiquet',
  'search:x_matching_results' => ':1 resultats coincidents',
  'search:one_matching_result' => '1 resultat coincident',
  'tickets:added' => 'El tiquet ha estat creat amb èxit.',
  'tickets:replied' => 'La resposta al tiquet ha estat guardada correctament.',
  'reminders:x_days_past_due' => ':1 dies vençuts',
  'global:project_expense' => 'Despesa',
  'global:reply' => 'Resposta',
  'expenses:before_you_can_add_expenses' => 'Abans de poder afegir qualsevol despesa, cal crear alguns :1 i :2.',
  'users:deactivate' => 'Desactivar',
  'global:download_csv' => 'Descarregar CSV',
  'tickets:user_updated_ticket' => ':1 ha actualitzat l\'estat del tiquet :2 sobre :3',
  'reports:collected' => 'Recollit',
  'clients:filter_clients' => 'Filtrar clients',
  'reports:uncollected' => 'No cobrades',
  'global:attach_file' => 'Adjuntar un fitxer (Mida màxima: :1)',
  'users:activate' => 'Activar',
  'global:group' => 'Grup',
  'users:confirm_password' => 'Confirmar contrasenya',
  'tasks:add_notes' => 'Afegeix notes',
  'users:edit_user' => 'Editar usuari',
  'invoices:not_associated_with_a_project' => '- Sense associar a un projecte -',
  'global:by_x_with_time' => 'Per :1, :2.',
  'projects:hourly_rate' => 'Tarifa per hora',
  'tasks:complete_this_task' => 'Completar aquesta tasca',
  'users:please_enter_information' => 'Si us plau, introdueixi la informació de l\'usuari a continuació.',
  'global:bcc_was_sent_to' => 'Aquest correu electrònic s\'ha enviat a :1 el :2.',
  'global:server_default' => 'Servidor per defecte (no recomanat)',
  'tickets:active_tickets' => 'Tiquets actius',
  'tasks:discuss_task' => 'Discutir la tasca',
  'projects:rate_type' => 'Tipus de tarifa',
  'tickets:leave_a_response' => 'Deixar una resposta',
  'tasks:task_notes' => 'Notes de tasca',
  'error:already_being_dealt_with' => 'El problema ja ha estat reportat per una altra persona, i està sent tramitat. Estem treballant per resoldre el més aviat possible.',
  'error:no_user_found' => 'La vostra clau de llicència no està associada a cap usuari de pancakeapp.com, de manera que el seu error no s\'ha pogut enviar automàticament. Si això és inesperat, envieu un correu electrònic a support@pancakeapp.com i l\'ajudarem.',
  'error:fixed_in_version' => 'Aquest problema es va arreglar a Pancake {version}. Si encara no el té, actualitzi Pancake.',
  'global:and' => 'I',
  'error:php_outdated' => 'La versió de PHP que està utilitzant està desactualitzada.',
  'error:pancake_will_stop_supporting_it' => 'Pancake podria deixar de suportar-ho en qualsevol moment.',
  'error:scanning' => 'Escanejant, si us plau esperi...',
  'error:using_php_53' => 'Està utilitzant PHP 5.3, que ha estat desactualitzat des de juliol de 2013 i ja no està suportat pel Grup PHP.',
  'error:upgrade_php' => 'Vostè ha d\'actualitzar la seva versió de PHP a la versió 5,5 com a mínim (la idònia és 5.6). Per fer-ho, si us plau parli amb el vostre administrador del servidor i demani-li que actualitzi PHP.',
  'error:scan_result_success' => 'Pancake està en perfecte estat i no ha estat alterat de cap manera. Tot està correcte.',
  'error:unknown_error_scanning' => 'S\'ha produït un error desconegut mentre s\'escanejava.',
  'error:scan' => 'Escanejar',
  'error:scan_result_failure_deleted_one' => 'El fitxer ":1" no existeix',
  'error:scan_result_failure_deleted_other' => 'Fitxers tipus :1 no existeixen.',
  'error:scan_result_failure_modified_one' => 'Un :1 de l\'arxiu ha estat modificat.',
  'error:why_update' => 'Seguint amb aquesta versió de PHP, s\'està perdent una sèrie de millores de rendiment i seguretat, així com moltes correccions d\'errors.',
  'error:click_here_for_instructions' => 'Feu clic aquí per veure les instruccions',
  'error:using_php_54' => 'Està utilitzant PHP 5.4, que està actualitzat des de setembre de 2014 i ja no és suportat pel Grup PHP.',
  'error:scan_pancake' => 'Escanegeu el vostre Pancake per incidències relacionades amb els arxius.',
  'error:scan_result_failure_heading' => 'Hi ha problemes amb els seus arxius de Pancake.',
  'error:scan_result_failure_how_to_fix' => 'Per resoldre aquests problemes, haurà d\'actualitzar manualment els fitxers de Pancake.',
  'error:scan_result_failure_modified_other' => 'S\'han modificat :1 fitxers',
  'error:and_x_others' => '... i els :1 altres.',
  'global:archived' => 'Arxivat',
  'proposals:archived' => 'Heu arxivat la proposta #:1 amb èxit.',
  'global:restore' => 'Restaurar',
  'invoices:archived' => 'Heu arxivat la factura #:1 amb èxit.',
  'proposals:restored' => 'Heu arxivat la proposta #:1 amb èxit.',
  'invoices:restored' => 'Heu arxivat el compte en un #:1 amb èxit.',
  'global:archive' => 'Arxivar',
  'estimates:archived' => 'Heu arxivat el pressupost #:1 amb èxit.',
  'estimates:restored' => 'Heu restaurat aproximadament un #:1 amb èxit.',
  'credit_notes:archived' => 'Heu arxivat la nota de crèdit #:1 amb èxit.',
  'proposals:list_all' => 'Totes les Propostes',
  'credit_notes:restored' => 'Heu restaurat la nota de crèdit #:1 amb èxit.',
  'proposals:list_accepted' => 'Propostes Acceptades',
  'error:scan_pancake_explanation' => 'De vegades podrien sorgir problemes a causa d\'una actualització fallida o causa dels problemes de permisos que causen que els teus arxius de Pancake es corrompin durant una actualització. Feu servir això per comprovar el vostre Pancake davant de qualsevol tipus de problemes.',
  'proposals:list_archived' => 'Propostes Arxivades',
  'proposals:list_unanswered' => 'Propostes sense resposta. ',
  'proposals:list_rejected' => 'Propostes Rebutjades',
  'invoices:credit_notes_archived' => 'Notes d\'Abonament Arxivades',
  'invoices:invoices_archived' => 'Factures Arxivades',
  'invoices:estimates_archived' => 'Estimacions Arxivades',
  'estimates:estimates_unsent' => 'Estimacions no enviades',
  'tickets:link_to_ticket' => 'Enllaç a la butlleta: :1',
  'tickets:invoice_for_ticket' => 'Butlleta #:1 - :2',
  'dashboard:outstanding_invoices' => 'Factures Pendents',
  'dashboard:view_all_outstanding_invoices' => 'Veure totes les factures pendents',
  'expenses:missing_category' => 'No ha seleccionat una categoria.',
  'expenses:missing_supplier' => 'Vosté no ha seleccionat un proveïdor.',
  'error:update_system' => 'Error d\'actualització',
  'error:update_system_cannot_update_file' => 'Pancake ha estat incapaç de modificar un o més dels seus arxius durant l\'actualització.',
  'error:update_system_cannot_update' => 'Pancake ha estat incapaç de descarregar l\'actualització correctament.',
  'error:update_system_solutions' => 'L\'actualització no s\'ha pogut completar, i el seu Pancake pot estar en aquests moments en un estat parcialment actualitzat, el que li causarà errors. Vostè haurà d\'actualitzar manualment els seus arxius Pancake per resoldre el problema. <br/><br/> :1 <br/><br/> Aquests errors poden ocórrer a causa d\'un problema amb els permisos d\'arxius. Si Pancake no té accés d\'escriptura a tots els seus arxius, no és capaç d\'actualitzar-se a si mateix correctament. En la majoria dels servidors, això es gestiona de forma automàtica, però un petit nombre de servidors podria requerir intervenció manual.',
  'error:update_without_ftp' => 'Si no té accés al FTP (o no voleu utilitzar el FTP), però té accés a SSH al seu Pancake, <a class="blue-btn" href="https://www.pancakeapp.com/faq/update-without-ftp" target="_blank">faci clic aquí </a> per a saber com actualitzar sense FTP.',
  'proposals:missing_client' => 'No heu seleccionat un client.',
  'gateways:direct_debit' => 'Dèbit directe',
  'error:no_permissions_solutions' => 'Podeu resoldre això permetent que la carpeta sigui editable. En general, això es fa amb CHMOD 0777, però pot haver altres maneres (per exemple, mitjançant el tauler de control del seu hosting web).',
  'error:you_cannot_report_this_non_server_error' => 'No pot informar d\'aquest problema al Suport de Pancake perquè aquest no és un problema amb Pancake.',
  'error:no_permissions_explanation' => 'Pancake no té permís per a crear arxius a <code>:1</code>.',
  'settings:decimal_places' => ':1 posicions decimals',
  'settings:currency_format' => 'Format de moneda',
  'settings:no_notify_email' => 'Vosté no té una adreça de correu electrònic establerta per a la <a href=":1">identitat de la seva empresa</a>.<br/>Pancake no pot enviar correu electrònic.',
  'settings:add_another_business' => 'Afegir un altre negoci',
  'global:auto_send_needs_pancake_cron_job' => 'Per a enviar factures automàticament, cal que configuri una <a target="_blank" href="https://www.pancakeapp.com/documentation/cron">Tasca de Cron de Pancake</a>.',
  'global:you_need_pancake_cron_job' => 'Per a utilitzar factures recorrents, cal que configure la <a target="_blank" href="https://www.pancakeapp.com/documentation/cron">Tasca de Cron de Pancake</a>.',
  'settings:always_autosend' => 'Auto enviar factures per defecte',
  'settings:send_x_days_before_explain' => "Nombre de dies per defecte fins que una factura venç per a enviar-la al client.",  

	 # Begin v4.12.0 changes
	"invoice:description" => "Descripció",
	"invoices:charge_when_due" => "Cobrar quan venci",
	"invoices:auto_charge" => "Cobrar al client automáticament",
	"invoices:pancake_will_charge_when_invoice_is_due" => "Pancake cobrarà automàticament a aquest client quan es faci la factura, utilitzant els detalls de pagament desats.",
	"invoices:pancake_cannot_auto_charge" => "No hi ha dades de pagament desades per aquest client, de manera que Pancake no pot cobrar automàticament. El client ha de pagar-vos mitjançant Stripe almenys una vegada per desar els detalls del pagament.",
	"invoices:auto_charge_needs_pancake_cron_job" => 'Per a cobrar automàticament als clients, has de configurar el <a target="_blank" href="https://www.pancakeapp.com/documentation/cron">Pancake Cron Job</a>.',
	"global:or" => "o",
	"invoices:could_not_auto_charge" => "Pancake no ha pogut cobrar al vostre client automàticament. El vostre client haurà de pagar la Factura #:1 manualment.",
	"invoices:auto_charged" => "S\'ha cobrat al vostre client la Factura #:1. La factura ara està pagada.",
	"settings:gmail_setup_successfully" => "Heu connectat el Pancake amb el vostre compte de Gmail amb èxit.",
	"settings:pancake_uses_our_servers" => "Nota: Pancake utilitza servidors Pancake per assegurar-vos que el permís per utilitzar Gmail no caduqui. <br /> No es guarda cap informació de cap tipus. Si teniu el vostre compte de Google per a desenvolupadors, podeu <a target='_blank' href='https://www.pancakeapp.com/faq/google-oauth'> utilitzar el vostre propi servidor</a>.",
	"settings:you_are_signed_in" => "You are signed in as :1.<br />Click the button below if you need to update your details or use a different account.",
	"settings:you_are_using_old_auth" => "Pancake is currently sending email as :1 using your email and password.<br />Click the button below to upgrade to a more secure way of using Gmail.",
	"invoices:send_now" => "Enviar factura",
	"credit_notes:messageupdated" => "La nota de pagament o abonament s\'ha actualitzat correctament!",
	'credit_notes:resend' => 'Reenviar nota de pagament o abonament',
	"global:support" => "Ajut / Suport",
	"settings:filesystem" => "On emmegatzemar les pujades",
	"settings:filesystem_local" => "Carpeta de pujades de fitxers",
	"filesystem:s3_access_key" => "Clau d\'accés",
	"filesystem:s3_secret_key" => "Clau secreta",
	"filesystem:s3_prefix" => "Carpeta (opcional)",
	"filesystem:s3_bucket" => "S3 Bucket",
	"invoices:amount_due" => "Quantitat debuda",
	"invoices:due_date" => "Data de venciment",
	"settings:filesystem_explain" => "Nota: Si canvieu aquesta configuració, Pancake copiarà tots els fitxers al vostre lloc d'emmagatzematge nou. No haurà de fer res més.",
	# End v4.12.0 changes 
  
);
/** End of file: pancake_lang.php **/
